<?php

namespace Vtlabs\Support\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Support\Models\Support;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Support\Filters\SupportFilter;
use Vtlabs\Support\Http\Resources\Admin\SupportAdminResource;

class SupportController extends Controller
{
    public function index(Request $request)
    {
        return SupportAdminResource::collection(Support::filter($request->all(), SupportFilter::class)->paginate());
    }

    public function destroy(Support $support)
    {
        Gate::authorize('delete');

        $support->delete();

        return response()->json([], 200);
    }

    public function show(Support $support)
    {
        return new SupportAdminResource($support);
    }

    public function update(Request $request, Support $support)
    {
        $request->validate([
            'is_resolved' => 'sometimes|boolean',
        ]);

        $support->fill($request->only(['is_resolved']));
        $support->save();

        return new SupportAdminResource($support);
    }
}
