<?php

namespace Vtlabs\Support\Filters;

use EloquentFilter\ModelFilter;
use Illuminate\Support\Facades\App;

class SupportFilter extends ModelFilter
{
    public function setup()
    {
        if ($this->input('_sort') && $this->input('_order')) {
            $sortColumn = $this->input('_sort');
            $sortOrder = $this->input('_order');
            if(in_array($sortColumn, ['id', 'created_at'])) {
                $this->orderBy($sortColumn, $sortOrder);
            } else {
                $this->latest();
            }
        }
    }

    public function name($name)
    {
        return $this->whereLike('name', $name);
    }

    public function email($email)
    {
        return $this->whereLike('email', $email);
    }

    public function message($message)
    {
        return $this->whereLike('message', $message);
    }
}
