<?php

namespace Vtlabs\Smartstudy;

use Illuminate\Support\ServiceProvider;

class SmartstudyServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__ . '/../config/vtlabs_smartstudy.php' => config_path('vtlabs_smartstudy.php'),
        ], 'config');

        // translations
        $this->loadTranslationsFrom(__DIR__ . '/../resources/lang', 'vtlabs_smartstudy');
        $this->publishes([
            __DIR__ . '/../resources/lang' => resource_path('lang/vendor/vtlabs_smartstudy'),
        ], 'translations');

        $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');

        $this->loadRoutesFrom(__DIR__ . '/../routes/api.php');
    }
}
