<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Vtlabs\Smartstudy\Models\Syllabus;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;

class Syllabuscontent extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait,
        HasTranslations;

    protected $table = 'smartstudy_syllabus_contents';

    protected $guarded = [];

    protected $casts = [
        'title' => 'json',
        'meta' => 'json',
        'price' => 'numeric'
    ];

    public $translatable = ['title'];

    public function syllabus()
    {
        return $this->belongsTo(Syllabus::class);
    }
}
