<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Vtlabs\Smartstudy\Models\School;
use Vtlabs\Smartstudy\Models\Subject;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;

class Syllabus extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait,
        HasTranslations;

    protected $table = 'smartstudy_syllabuses';

    protected $guarded = [];

    protected $casts = [
        'title' => 'json',
        'description' => 'json',
        'meta' => 'json',
        'sort_order' => 'integer'
    ];

    public $translatable = ['title', 'description'];

    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    public function content()
    {
        return $this->hasMany(Syllabuscontent::class);
    }
}
