<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Vtlabs\Smartstudy\Models\School;
use Vtlabs\Smartstudy\Models\Faculty;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;

class Subject extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait,
        HasTranslations;

    protected $table = 'smartstudy_subjects';

    protected $guarded = [];

    protected $casts = [
        'title' => 'json',
        'description' => 'json',
        'meta' => 'json'
    ];

    public $translatable = ['title', 'description'];

    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function schoolclass()
    {
        return $this->belongsTo(Schoolclass::class, 'class_id');
    }

    public function faculty()
    {
        return $this->belongsTo(Faculty::class);
    }
}
