<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Smartstudy\Models\Quizoption;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;

class Quizquestion extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait,
        HasTranslations;

    protected $table = 'smartstudy_quiz_questions';

    protected $guarded = [];

    protected $casts = [
        'question' => 'json',
        'meta' => 'json'
    ];

    public $translatable = ['question'];

    public  $timestamps = false;

    public function quiz()
    {
        return $this->belongsTo(Quiz::class);
    }

    public function options()
    {
        return $this->hasMany(Quizoption::class, 'question_id');
    }
}
