<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;
use Vtlabs\Smartstudy\Models\Quizquestion;
use Spatie\Translatable\HasTranslations;

class Quizoption extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait,
        HasTranslations;

    protected $table = 'smartstudy_quiz_question_options';

    protected $guarded = [];

    protected $casts = [
        'title' => 'json',
        'meta' => 'json',
        'is_correct' => 'boolean'
    ];

    public $translatable = ['title'];

    public  $timestamps = false;

    public function question()
    {
        return $this->belongsTo(Quizquestion::class);
    }
}
