<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Smartstudy\Models\Quizoption;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;

class Quizattempt extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait,
        HasTranslations;

    protected $table = 'smartstudy_quiz_attempts';

    protected $guarded = [];

    protected $casts = [
        'is_correct' => 'integer',
        'is_skipped' => 'integer'
    ];

    public  $timestamps = false;

    public function quiz()
    {
        return $this->belongsTo(Quiz::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function question()
    {
        return $this->belongsTo(Quizquestion::class);
    }

    public function option()
    {
        return $this->belongsTo(Quizoption::class);
    }

    public function scopeAttempted($query, $studentid, $quizid)
    {
        return $query->where('student_id', $studentid)->where('quiz_id', $quizid);
    }
}
