<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Smartstudy\Models\School;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;

class Faculty extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait,
        HasTranslations;

    protected $table = 'smartstudy_faculties';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
        'description' => 'json'
    ];

    public $translatable = ['description'];

    public static function findByUser($userId)
    {
        return Faculty::where('user_id', $userId)->firstOrFail();
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function school()
    {
        return $this->belongsTo(School::class);
    }
}
