<?php

namespace Vtlabs\Smartstudy\Listeners;

use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Smartstudy\Models\Faculty;
use Vtlabs\Smartstudy\Models\Student;

class RoleAssignedListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  RoleAssigned $event
     * @return void
     */
    public function handle(RoleAssigned $event)
    {
        if (in_array('student', $event->roles)) {
            if (!Student::where('user_id', $event->user->id)->exists()) {
                Student::create([
                    'user_id' => $event->user->id
                ]);
            }
        }

        if (in_array('faculty', $event->roles)) {
            if (!Faculty::where('user_id', $event->user->id)->exists()) {
                Faculty::create([
                    'user_id' => $event->user->id
                ]);
            }
        }

        return true;
    }
}
