<?php

namespace Vtlabs\Smartstudy\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Smartstudy\Http\Resources\SchoolclassResource;

class SubjectResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),            
            'meta' => $this->meta,
            'school_id' => $this->school_id,
            'school' => new SchoolResource($this->school),
            'class_id' => $this->class_id,
            'schoolclass' => new SchoolclassResource($this->schoolclass),
            'faculty_id' => $this->faculty_id,
            'faculty' => new FacultyResource($this->faculty),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
