<?php

namespace Vtlabs\Smartstudy\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Smartstudy\Models\Quizattempt;

class QuizattemptSummaryResource extends JsonResource
{
    public function toArray($request)
    {
        $quizAttempts = Quizattempt::where('quiz_id', $this->resource['quiz_id'])->where('student_id', $this->resource['student_id']);

        $quizCorrectAttempts = clone $quizAttempts;
        $quizSkippedAttempts = clone $quizAttempts;

        $totalCount = $quizAttempts->count();
        $correctCount = $quizCorrectAttempts->where('is_correct', 1)->count();
        $skippedCount = $quizSkippedAttempts->where('is_skipped', 1)->count();
        $totalWrong = $totalCount - $correctCount - $skippedCount;

        return [
            'leaderboard_rank' => $this->resource['leaderboard_rank'],
            'score' => $this->resource['score'],
            'total_correct' => $correctCount,
            'total_skipped' => $skippedCount,
            'total_wrong' => $totalWrong >= 0 ? $totalWrong : 0,
            'quiz_id' => $this->resource['quiz_id'],
            'student_id' => $this->resource['student_id']
        ];
    }
}
