<?php

namespace Vtlabs\Smartstudy\Http\Resources;

use Illuminate\Support\Facades\Auth;
use Vtlabs\Smartstudy\Models\Student;
use Vtlabs\Smartstudy\Models\Quizattempt;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Smartstudy\Http\Resources\SubjectResource;
use Vtlabs\Smartstudy\Http\Resources\QuizquestionResource;
use Vtlabs\Smartstudy\Models\Quizleaderboard;

class QuizResource extends JsonResource
{
    public function toArray($request)
    {
        $attemptSummary = null;

        if (Auth::id() && Auth::user()->hasRole('student')) {
            $student = Student::findByUser(Auth::id());

            if (Quizattempt::attempted($student->id, $this->id)->exists()) {
                $attemptSummary = new QuizattemptSummaryResource([
                    'quiz_id' => $this->id,
                    'student_id' => $student->id,
                    'score' => Quizleaderboard::where('quiz_id', $this->id)->where('student_id', $student->id)->first()->score,
                    'leaderboard_rank' => 0
                ]);
            }
        }

        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),
            'meta' => $this->meta,
            'quiz_date' => $this->quiz_date,
            'duration_minutes' => $this->duration_minutes,
            'school_id' => $this->school_id,
            'school' => new SchoolResource($this->school),
            'class_id' => $this->class_id,
            'schoolclass' => new SchoolclassResource($this->schoolclass),
            'subject_id' => $this->subject_id,
            'subject' => new SubjectResource($this->subject),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'questions' => QuizquestionResource::collection($this->questions),
            'questions_count' => $this->questions()->count(),
            'attempt_summary' => $attemptSummary
        ];
    }
}
