<?php

namespace Vtlabs\Smartstudy\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class FacultyResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),
            'user' => new UserResource($this->user),
            'school_id' => $this->school_id,
            'school' => new SchoolResource($this->school),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
