<?php

namespace Vtlabs\Smartstudy\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Smartstudy\Models\Syllabus;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Smartstudy\Filters\SyllabusFilter;
use Vtlabs\Smartstudy\Http\Resources\SyllabusResource;

class SyllabusController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'subject' => 'sometimes|exists:smartstudy_subjects,id'
        ]);

        $syllabus = Syllabus::filter($request->all(), SyllabusFilter::class);

        return SyllabusResource::collection($syllabus->paginate());
    }

    public function show(Syllabus $syllabus)
    {
        return new SyllabusResource($syllabus);
    }
}
