<?php

namespace Vtlabs\Smartstudy\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Smartstudy\Models\Subject;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Smartstudy\Filters\SubjectFilter;
use Vtlabs\Smartstudy\Http\Resources\SubjectResource;

class SubjectController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'school' => 'sometimes|exists:smartstudy_schools,id',
            'schoolclass' => 'sometimes|exists:smartstudy_school_classes,id',
        ]);

        $subjects = Subject::filter($request->all(), SubjectFilter::class);

        return SubjectResource::collection($subjects->get());
    }

    public function show(Subject $subject)
    {
        return new SubjectResource($subject);
    }
}
