<?php

namespace Vtlabs\Smartstudy\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Smartstudy\Models\Session;
use Vtlabs\Smartstudy\Filters\SessionFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Smartstudy\Http\Resources\SessionResource;

class SessionController extends Controller
{
    public function __construct()
    {
        if (array_key_exists('HTTP_AUTHORIZATION', $_SERVER)) {
            $this->middleware('auth:api');
        }
    }
    
    public function index(Request $request)
    {
        $request->validate([
            'school' => 'sometimes|exists:smartstudy_schools,id',
            'schoolclass' => 'sometimes|exists:smartstudy_school_classes,id',
            'subject' => 'sometimes|exists:smartstudy_subjects,id',
            'faculty' => 'sometimes|exists:smartstudy_faculties,id'
        ]);

        $session = Session::filter($request->all(), SessionFilter::class)->orderBy('session_date', 'desc');

        return SessionResource::collection($session->paginate());
    }
}
