<?php

namespace Vtlabs\Smartstudy\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Smartstudy\Models\Schoolclass;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Smartstudy\Filters\SchoolclassFilter;
use Vtlabs\Smartstudy\Http\Resources\SchoolclassResource;

class SchoolclassController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'school' => 'sometimes|exists:smartstudy_schools,id'
        ]);

        $schoolclasses = Schoolclass::filter($request->all(), SchoolclassFilter::class);

        if ($request->pagination == '0') {
            $schoolclasses = $schoolclasses->get();
        } else {
            $schoolclasses = $schoolclasses->paginate();
        }

        return SchoolclassResource::collection($schoolclasses);
    }
}
