<?php

namespace Vtlabs\Smartstudy\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Smartstudy\Models\Schoolclass;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Smartstudy\Filters\SchoolclassFilter;
use Vtlabs\Smartstudy\Http\Resources\Admin\SchoolclassAdminResource;

class SchoolclassController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'school' => 'sometimes|exists:smartstudy_schools,id'
        ]);

        $schoolclasses = Schoolclass::filter($request->all(), SchoolclassFilter::class);

        if ($request->pagination == '0') {
            $schoolclasses = $schoolclasses->get();
        } else {
            $schoolclasses = $schoolclasses->paginate();
        }

        return SchoolclassAdminResource::collection($schoolclasses);
    }

    public function show(Schoolclass $schoolclass)
    {
        return new SchoolclassAdminResource($schoolclass);
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
            'school_id' => 'required|exists:smartstudy_schools,id',
            'meta' => 'sometimes|json|nullable'
        ]);

        $request->merge([
            "meta" => $request->meta ? json_decode($request->meta) : null
        ]);

        $schoolclass = Schoolclass::create($request->all());

        return new SchoolclassAdminResource($schoolclass);
    }

    public function update(Schoolclass $schoolclass, Request $request)
    {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
            'school_id' => 'required|exists:smartstudy_schools,id',
            'meta' => 'sometimes|json|nullable'
        ]);

        $request->merge([
            "meta" => $request->meta ? json_decode($request->meta) : null
        ]);

        $schoolclass->fill($request->all());
        $schoolclass->save();

        return new SchoolclassAdminResource($schoolclass);
    }

    public function destroy(Schoolclass $schoolclass)
    {
        Gate::authorize('delete');

        $schoolclass->delete();

        return response()->json([], 204);
    }
}
