<?php
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use Illuminate\Http\Request;

Route::middleware('api')->prefix('api')->name('api')->namespace('Vtlabs\Smartstudy\Http\Controllers\Api')->group(function () {

    // admin api
    Route::namespace('Admin')->name('admin/smartstudy')->prefix('admin')->group(function () {
        Route::middleware('auth:api')->group(function () {
            Route::apiResource('schools', 'SchoolController');
            Route::apiResource('schoolclasses', 'SchoolclassController');
            Route::apiResource('subjects', 'SubjectController');
            Route::apiResource('syllabus', 'SyllabusController');
            Route::apiResource('students', 'StudentController');
            Route::apiResource('faculty', 'FacultyController');
            Route::apiResource('quiz', 'QuizController');
            Route::apiResource('session', 'SessionController');
        });
    });

    // app/web api
    Route::prefix('smartstudy')->group(function () {
        Route::get('subjects', 'SubjectController@index');
        
        Route::get('syllabus', 'SyllabusController@index');
        
        Route::get('quiz', 'QuizController@index');

        Route::get('session', 'SessionController@index');

        Route::get('faculty/list', 'FacultyController@index');

        Route::get('schools', 'SchoolController@index');
        Route::get('schools/{school}', 'SchoolController@show');

        Route::get('schoolclasses', 'SchoolclassController@index');

        Route::middleware('auth:api')->group(function () {
            Route::get('students/my-profile', 'StudentController@showMyProfile');
            Route::put('students/my-profile', 'StudentController@updateMyProfile');
            Route::get('students/insights', 'StudentController@insights');
            
            Route::get('faculty/my-profile', 'FacultyController@showMyProfile');

            Route::get('faculty/notify-students', 'FacultyController@notifyStudents');

            Route::post('quiz/{quiz}/attempt', 'QuizController@attempt');

            Route::get('quiz/{quiz}/leaderboard', 'QuizController@leaderboard');
        });
    });
});
