<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuizes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smartstudy_quizes', function (Blueprint $table) {
            $table->increments('id');
            $table->json('title');
            $table->json('description')->nullable();
            $table->json('meta')->nullable();
            $table->dateTime('quiz_date');
            $table->integer('duration_minutes')->unsigned()->default(0);
            $table->timestamps();

            $table->integer('school_id')->unsigned()->nullable();
            $table->foreign('school_id')->references('id')->on('smartstudy_schools')->onDelete('cascade');

            $table->integer('class_id')->unsigned()->nullable();
            $table->foreign('class_id')->references('id')->on('smartstudy_school_classes')->onDelete('cascade');

            $table->integer('subject_id')->unsigned();
            $table->foreign('subject_id')->references('id')->on('smartstudy_subjects')->onDelete('cascade');
        });

        Schema::create('smartstudy_quiz_questions', function (Blueprint $table) {
            $table->increments('id');
            $table->json('question');
            $table->json('meta')->nullable();

            $table->integer('quiz_id')->unsigned()->nullable();
            $table->foreign('quiz_id')->references('id')->on('smartstudy_quizes')->onDelete('cascade');
        });

        Schema::create('smartstudy_quiz_question_options', function (Blueprint $table) {
            $table->increments('id');
            $table->json('title');
            $table->json('meta')->nullable();
            $table->boolean('is_correct')->default(false);

            $table->integer('question_id')->unsigned()->nullable();
            $table->foreign('question_id')->references('id')->on('smartstudy_quiz_questions')->onDelete('cascade');
        });

        Schema::create('smartstudy_quiz_attempts', function (Blueprint $table) {
            $table->increments('id');
            $table->boolean('is_correct')->default(false);
            $table->boolean('is_skipped')->default(false);
            $table->timestamps();

            $table->integer('quiz_id')->unsigned()->nullable();
            $table->foreign('quiz_id')->references('id')->on('smartstudy_quizes')->onDelete('cascade');

            $table->integer('question_id')->unsigned()->nullable();
            $table->foreign('question_id')->references('id')->on('smartstudy_quiz_questions')->onDelete('cascade');

            $table->integer('option_id')->unsigned()->nullable();
            $table->foreign('option_id')->references('id')->on('smartstudy_quiz_question_options')->onDelete('cascade');

            $table->integer('student_id')->unsigned()->nullable();
            $table->foreign('student_id')->references('id')->on('smartstudy_students')->onDelete('cascade');
        });

        Schema::create('smartstudy_quiz_leaderboards', function (Blueprint $table) {
            $table->float('score')->unsigned()->default(0.0);

            $table->integer('quiz_id')->unsigned()->nullable();
            $table->foreign('quiz_id')->references('id')->on('smartstudy_quizes')->onDelete('cascade');

            $table->integer('student_id')->unsigned()->nullable();
            $table->foreign('student_id')->references('id')->on('smartstudy_students')->onDelete('cascade');

            $table->integer('subject_id')->unsigned();
            $table->foreign('subject_id')->references('id')->on('smartstudy_subjects')->onDelete('cascade');

            $table->integer('class_id')->unsigned()->nullable();
            $table->foreign('class_id')->references('id')->on('smartstudy_school_classes')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('smartstudy_quizes', function (Blueprint $table) {
            $table->dropForeign(['school_id']);
            $table->dropForeign(['class_id']);
            $table->dropForeign(['subject_id']);
        });

        Schema::dropIfExists('smartstudy_quizes');
    }
}
