<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSchoolClasses extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smartstudy_school_classes', function (Blueprint $table) {
            $table->increments('id');
            $table->json('title');
            $table->json('description')->nullable();
            $table->json('meta')->nullable();
            $table->timestamps();

            $table->integer('school_id')->unsigned();
            $table->foreign('school_id')->references('id')->on('smartstudy_schools')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('smartstudy_school_classes', function (Blueprint $table) {
            $table->dropForeign(['school_id']);
        });

        Schema::dropIfExists('smartstudy_school_classes');
    }
}
