<?php

namespace Vtlabs\Smartstudy\Providers;

use Vtlabs\Core\Events\LoggedIn;
use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Smartstudy\Events\StartSession;
use Vtlabs\Smartstudy\Listeners\LoggedInListener;
use Vtlabs\Smartstudy\Listeners\RoleAssignedListener;
use Vtlabs\Smartstudy\Listeners\StartSessionListener;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        LoggedIn::class => [LoggedInListener::class],
        RoleAssigned::class => [RoleAssignedListener::class],
        StartSession::class => [StartSessionListener::class],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
