<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Smartstudy\Models\School;
use Illuminate\Database\Eloquent\Model;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Vtlabs\Smartstudy\Models\Schoolclass;
use Spatie\MediaLibrary\HasMedia\HasMedia;

class Student extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait;

    protected $table = 'smartstudy_students';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json'
    ];

    public static function findByUser($userId)
    {
        return Student::where('user_id', $userId)->firstOrFail();
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function schoolclass()
    {
        return $this->belongsTo(Schoolclass::class, 'class_id');
    }
}
