<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Vtlabs\Smartstudy\Models\School;
use Vtlabs\Smartstudy\Models\Faculty;
use Vtlabs\Smartstudy\Models\Subject;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Smartstudy\Models\Schoolclass;
use Vtlabs\Smartstudy\Models\Quizquestion;

class Session extends Model
{
    use Filterable,
        HasTranslations;

    protected $table = 'smartstudy_sessions';

    protected $guarded = [];

    protected $casts = [
        'title' => 'json',
        'description' => 'json',
        'meta' => 'json',
        'duration_minutes' => 'integer'
    ];

    public $translatable = ['title', 'description'];

    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function schoolclass()
    {
        return $this->belongsTo(Schoolclass::class, 'class_id');
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    public function questions()
    {
        return $this->hasMany(Quizquestion::class);
    }

    public function faculty()
    {
        return $this->belongsTo(Faculty::class);
    }
}
