<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Vtlabs\Smartstudy\Models\School;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;

class Schoolclass extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait,
        HasTranslations;

    protected $table = 'smartstudy_school_classes';

    protected $guarded = [];

    protected $casts = [
        'title' => 'json',
        'description' => 'json',
        'meta' => 'json'
    ];

    public $translatable = ['title', 'description'];

    public function school()
    {
        return $this->belongsTo(School::class);
    }
}
