<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;
use Spatie\Translatable\HasTranslations;

class School extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait,
        HasTranslations;

    protected $table = 'smartstudy_schools';

    protected $guarded = [];

    protected $casts = [
        'title' => 'json',
        'short_description' => 'json',
        'description' => 'json',
        'meta' => 'json',
        'longitude' => 'float',
        'latitude' => 'float'
    ];

    public $translatable = ['title', 'short_description', 'description'];
}
