<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;

class Quizleaderboard extends Model
{
    use Filterable;

    protected $table = 'smartstudy_quiz_leaderboards';

    protected $guarded = [];

    protected $casts = [
        'score' => 'float',
        'is_skipped' => 'integer'
    ];
    
    public function quiz()
    {
        return $this->belongsTo(Quiz::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    public function schoolclass()
    {
        return $this->belongsTo(Schoolclass::class, 'class_id');
    }
}
