<?php

namespace Vtlabs\Smartstudy\Models;

use EloquentFilter\Filterable;
use Vtlabs\Smartstudy\Models\School;
use Vtlabs\Smartstudy\Models\Subject;
use Illuminate\Database\Eloquent\Model;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Vtlabs\Smartstudy\Models\Schoolclass;
use Spatie\MediaLibrary\HasMedia\HasMedia;
use Vtlabs\Smartstudy\Models\Quizquestion;
use Spatie\Translatable\HasTranslations;

class Quiz extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait,
        HasTranslations;

    protected $table = 'smartstudy_quizes';

    protected $guarded = [];

    protected $casts = [
        'title' => 'json',
        'description' => 'json',
        'meta' => 'json',
        'duration_minutes' => 'integer'
    ];

    public $translatable = ['title', 'description'];

    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function schoolclass()
    {
        return $this->belongsTo(Schoolclass::class, 'class_id');
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    public function questions()
    {
        return $this->hasMany(Quizquestion::class);
    }
}
