<?php

namespace Vtlabs\Smartstudy\Listeners;

use Vtlabs\Core\Models\User\User;
use Vtlabs\Smartstudy\Models\Session;
use Vtlabs\Smartstudy\Models\Student;
use Vtlabs\Core\Models\PushNotification;
use Vtlabs\Core\Jobs\SendPushNotification;
use Vtlabs\Smartstudy\Events\StartSession;

class StartSessionListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  LoggedIn $event
     * @return void
     */
    public function handle(StartSession $event)
    {
        $session = Session::find($event->sessionId);
        $notificationObjs = User::whereIn('id', Student::where('class_id', $event->classId)->pluck('user_id'))->pluck('notification');
        $notificationIds = [];

        foreach ($notificationObjs as $notificationObj) {
            $notificationIds[] = $notificationObj['student'];
        }

        $pushNotification = new PushNotification('en', 'student', __('vtlabs_smartstudy::messages.notification_start_session_title', ['faculty' => $session->faculty->user->name]), __('vtlabs_smartstudy::messages.notification_start_session_body'), $notificationIds, []);

        config('queue.use_queue') ? SendPushNotification::dispatch($pushNotification) : SendPushNotification::dispatchAfterResponse($pushNotification);

        return true;
    }
}
