<?php

namespace Vtlabs\Smartstudy\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Smartstudy\Http\Resources\SubjectResource;

class SyllabusResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),            
            'meta' => $this->meta,
            'sort_order' => $this->sort_order,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'school_id' => (int)$this->school_id,
            'school' => new SchoolResource($this->school),
            'subject_id' => (int) $this->subject_id,
            'subject' => new SubjectResource($this->subject),
        ];
    }
}
