<?php

namespace Vtlabs\Smartstudy\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Smartstudy\Http\Resources\SchoolResource;
use Vtlabs\Smartstudy\Http\Resources\SchoolclassResource;

class StudentResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,       
            'meta' => $this->meta,
            'user' => new UserResource($this->user),
            'school_id' => (int)$this->school_id,
            'school' => new SchoolResource($this->school),
            'class_id' => $this->class_id,
            'schoolclass' => new SchoolclassResource($this->schoolclass),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
