<?php

namespace Vtlabs\Smartstudy\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Smartstudy\Http\Resources\FacultyResource;
use Vtlabs\Smartstudy\Http\Resources\SubjectResource;

class SessionResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),
            'meta' => $this->meta,
            'session_date' => $this->session_date,
            'duration_minutes' => $this->duration_minutes,
            'school_id' => (int)$this->school_id,
            'school' => new SchoolResource($this->school),
            'class_id' => (int) $this->class_id,
            'schoolclass' => new SchoolclassResource($this->schoolclass),
            'subject_id' => (int) $this->subject_id,
            'subject' => new SubjectResource($this->subject),
            'faculty_id' => (int) $this->faculty_id,
            'faculty' => new FacultyResource($this->faculty),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
