<?php

namespace Vtlabs\Smartstudy\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SchoolResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'short_description' => $this->short_description,
            'short_description_translations' => $this->getTranslations('short_description'),            
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),            
            'meta' => $this->meta,
            'address' => $this->address,
            'longitude' => $this->longitude,
            'latitude' => $this->latitude,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
