<?php

namespace Vtlabs\Smartstudy\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Vtlabs\Smartstudy\Models\Quiz;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Smartstudy\Models\Student;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Smartstudy\Http\Resources\StudentResource;
use Vtlabs\Smartstudy\Models\Quizattempt;

class StudentController extends Controller
{
    public function showMyProfile(Request $request)
    {
        $student = Student::findByUser(Auth::user()->id);
        return new StudentResource($student);
    }

    public function insights(Request $request)
    {
        $overallRank = 0;
        $lastRank = 0;

        $student = Student::findByUser(Auth::user()->id);
        $currentClassId = $student->class_id;
        $studentChartData = DB::table('smartstudy_quiz_leaderboards')->select(DB::raw('AVG(score) as score_avg'), DB::raw('DAY(created_at) as period'), DB::raw('count(*) as total'))
            ->whereDate('created_at', '>', Carbon::now()->subdays(30))
            ->whereDate('created_at', '<=', Carbon::now())
            ->where('student_id', $student->id)
            ->where('class_id', $currentClassId)
            ->groupBy(DB::raw('DAY(created_at)'));

        $subjectWiseData = DB::table('smartstudy_quiz_leaderboards')->select(DB::raw('AVG(score) as score_avg'), 'subject_id', DB::raw('count(*) as total'))
            ->where('student_id', $student->id)
            ->where('class_id', $currentClassId)
            ->groupBy('subject_id');

        // overall rank
        $overallRankData = DB::select('SELECT *, FIND_IN_SET( score, (SELECT GROUP_CONCAT( DISTINCT score ORDER BY score DESC ) FROM smartstudy_quiz_leaderboards) ) AS leaderboard_rank FROM smartstudy_quiz_leaderboards where student_id=' . $student->id);

        if ($overallRankData && count($overallRankData) > 0) {
            $overallRank = $overallRankData[0]->leaderboard_rank;
        }

        // last rank
        $lastQuiz =  Quizattempt::where('student_id', $student->id)->latest()->first();
        if ($lastQuiz) {
            $lastRankData = DB::select('SELECT *, FIND_IN_SET( score, (SELECT GROUP_CONCAT( DISTINCT score ORDER BY score DESC ) FROM smartstudy_quiz_leaderboards) ) AS leaderboard_rank FROM smartstudy_quiz_leaderboards where quiz_id=' . $lastQuiz->quiz_id);

            if ($lastRankData && count($lastRankData) > 0) {
                $lastRank = $lastRankData[0]->leaderboard_rank;
            }
        }

        return response()->json([
            'score_chart_data' => $studentChartData->get(),
            'subject_wise_data' => $subjectWiseData->get(),
            'overall_rank' => $overallRank,
            'last_rank' => $lastRank
        ]);
    }

    public function updateMyProfile(Request $request)
    {
        $student = Student::findByUser(Auth::user()->id);

        $request->validate([
            'school_id' => 'required|exists:smartstudy_schools,id',
            'class_id' => 'required|exists:smartstudy_school_classes,id',
            'meta' => 'sometimes|json|nullable'
        ]);

        $request->merge([
            "meta" => $request->meta ? json_decode($request->meta) : null
        ]);

        $student->fill($request->only(['school_id', 'class_id', 'meta']));
        $student->save();

        return new StudentResource($student);
    }
}
