<?php

namespace Vtlabs\Smartstudy\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Smartstudy\Models\School;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Smartstudy\Http\Resources\SchoolResource;

class SchoolController extends Controller
{
    public function index(Request $request)
    {
        $schools = School::latest();
        if ($request->pagination == '0') {
            $schools = $schools->get();
        } else {
            $schools = $schools->paginate();
        }

        return SchoolResource::collection($schools);
    }
    
    public function show(School $school)
    {
        return new SchoolResource($school);
    }
}
