<?php

namespace Vtlabs\Smartstudy\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Smartstudy\Models\Faculty;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Smartstudy\Events\StartSession;
use Vtlabs\Smartstudy\Filters\FacultyFilter;
use Vtlabs\Smartstudy\Http\Resources\FacultyResource;

class FacultyController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'school' => 'sometimes|exists:smartstudy_schools,id',
        ]);

        $faculty = Faculty::filter($request->all(), FacultyFilter::class);

        if ($request->pagination == '0') {
            $faculty = $faculty->get();
        } else {
            $faculty = $faculty->paginate();
        }

        return FacultyResource::collection($faculty);
    }

    public function showMyProfile(Request $request)
    {
        $faculty = Faculty::findByUser(Auth::user()->id);
        return new FacultyResource($faculty);
    }

    public function updateMyProfile(Faculty $faculty, Request $request)
    {
        $faculty = Faculty::findByUser(Auth::user()->id);

        $request->validate([
            'school_id' => 'required|exists:smartstudy_schools,id',
            'meta' => 'sometimes|json|nullable',
            'description' => 'sometimes'
        ]);

        $request->merge([
            "meta" => $request->meta ? json_decode($request->meta) : null
        ]);

        $faculty->fill($request->only(['school_id', 'meta', 'description']));
        $faculty->save();

        return new FacultyResource($faculty);
    }

    public function notifyStudents(Request $request)
    {
        $request->validate([
            'class' => 'required|exists:smartstudy_school_classes,id',
            'session' => 'required|exists:smartstudy_sessions,id',
        ]);

        event(new StartSession($request->class, $request->session));

        return response()->json((object)[], 200);

    }
}
