<?php

namespace Vtlabs\Smartstudy\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Smartstudy\Models\Syllabus;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Smartstudy\Http\Resources\Admin\SyllabusAdminResource;

class SyllabusController extends Controller
{
    public function index(Request $request)
    {
        return SyllabusAdminResource::collection(Syllabus::latest()->paginate());
    }

    public function show(Syllabus $syllabu)
    {
        return new SyllabusAdminResource($syllabu);
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
            'school_id' => 'required|exists:smartstudy_schools,id',
            'subject_id' => 'required|exists:smartstudy_subjects,id',
            'sort_order' => 'required',
            'meta' => 'sometimes|json|nullable'
        ]);

        $request->merge([
            "meta" => $request->meta ? json_decode($request->meta) : null
        ]);

        $syllabus = Syllabus::create($request->all());

        return new SyllabusAdminResource($syllabus);
    }

    public function update(Syllabus $syllabu, Request $request)
    {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
            'school_id' => 'required|exists:smartstudy_schools,id',
            'subject_id' => 'required|exists:smartstudy_subjects,id',
            'sort_order' => 'required',
            'meta' => 'sometimes|json|nullable'
        ]);

        $request->merge([
            "meta" => $request->meta ? json_decode($request->meta) : null
        ]);

        $syllabu->fill($request->all());
        $syllabu->save();

        return new SyllabusAdminResource($syllabu);
    }

    public function destroy(Syllabus $syllabus)
    {
        Gate::authorize('delete');

        $syllabus->delete();

        return response()->json([], 204);
    }
}
