<?php

namespace Vtlabs\Smartstudy\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Smartstudy\Models\School;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Smartstudy\Http\Resources\Admin\SchoolAdminResource;

class SchoolController extends Controller
{
    public function index(Request $request)
    {
        $schools = School::latest();
        if ($request->pagination == '0') {
            $schools = $schools->get();
        } else {
            $schools = $schools->paginate();
        }

        return SchoolAdminResource::collection($schools);
    }

    public function show(School $school)
    {
        return new SchoolAdminResource($school);
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'short_description' => 'required',
            'description' => 'required',
            'address' => 'sometimes',
            'longitude' => 'sometimes|numeric|min:-180|max:180',
            'latitude' => 'sometimes|numeric|min:-90|max:90',
            'meta' => 'sometimes|json|nullable'
        ]);

        $request->merge([
            "meta" => $request->meta ? json_decode($request->meta) : null
        ]);

        $school = School::create($request->all());

        return new SchoolAdminResource($school);
    }

    public function update(Request $request, School $school)
    {
        $request->validate([
            'title' => 'required|max:255',
            'short_description' => 'required|max:255',
            'description' => 'required|max:500',
            'address' => 'sometimes',
            'longitude' => 'sometimes|numeric|min:-180|max:180',
            'latitude' => 'sometimes|numeric|min:-90|max:90',
            'meta' => 'sometimes|json|nullable'
        ]);

        $request->merge([
            "meta" => $request->meta ? json_decode($request->meta) : null
        ]);

        $school->fill($request->all());
        $school->save();

        return new SchoolAdminResource($school);
    }

    public function destroy(School $school)
    {
        Gate::authorize('delete');

        $school->delete();

        return response()->json([], 204);
    }
}
