<?php

namespace Vtlabs\Smartstudy\Filters;

use Carbon\Carbon;
use EloquentFilter\ModelFilter;

class SessionFilter extends ModelFilter
{
    public function setup()
    {
    }

    public function school($school)
    {
        return $this->where('school_id', $school);
    }

    public function schoolclass($schoolclass)
    {
        return $this->where('class_id', $schoolclass);
    }

    public function subject($subject)
    {
        return $this->where('subject_id', $subject);
    }

    public function faculty($faculty)
    {
        return $this->where('faculty_id', $faculty);
    }

    public function upcoming($upcoming) 
    {
        return $this->where('session_date', '>=', Carbon::now()->toDateString());
    }

    public function past($past) 
    {
        return $this->where('session_date', '<', Carbon::now()->toDateString());
    }
}
