<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSessions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smartstudy_sessions', function (Blueprint $table) {
            $table->increments('id');
            $table->json('title');
            $table->json('description')->nullable();
            $table->json('meta')->nullable();
            $table->dateTime('session_date');
            $table->integer('duration_minutes')->unsigned()->default(0);
            $table->timestamps();

            $table->integer('school_id')->unsigned()->nullable();
            $table->foreign('school_id')->references('id')->on('smartstudy_schools')->onDelete('cascade');

            $table->integer('class_id')->unsigned()->nullable();
            $table->foreign('class_id')->references('id')->on('smartstudy_school_classes')->onDelete('cascade');

            $table->integer('subject_id')->unsigned();
            $table->foreign('subject_id')->references('id')->on('smartstudy_subjects')->onDelete('cascade');

            $table->integer('faculty_id')->unsigned();
            $table->foreign('faculty_id')->references('id')->on('smartstudy_faculties')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('smartstudy_sessions', function (Blueprint $table) {
            $table->dropForeign(['school_id']);
            $table->dropForeign(['class_id']);
            $table->dropForeign(['subject_id']);
            $table->dropForeign(['faculty_id']);
        });

        Schema::dropIfExists('smartstudy_sessions');
    }
}
