<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSyllabuses extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smartstudy_syllabuses', function (Blueprint $table) {
            $table->increments('id');
            $table->json('title');
            $table->json('description')->nullable();
            $table->json('meta')->nullable();
            $table->integer('sort_order')->unsigned()->default(1);
            $table->timestamps();

            $table->integer('school_id')->unsigned();
            $table->foreign('school_id')->references('id')->on('smartstudy_schools')->onDelete('cascade');

            $table->integer('subject_id')->unsigned();
            $table->foreign('subject_id')->references('id')->on('smartstudy_subjects')->onDelete('cascade');
        });

        Schema::create('smartstudy_syllabus_contents', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->json('meta')->nullable();
            $table->string('source_url', 500);
            $table->string('type');
            $table->double('price', 8, 2)->default(0.0);
            $table->timestamps();

            $table->integer('syllabus_id')->unsigned();
            $table->foreign('syllabus_id')->references('id')->on('smartstudy_syllabuses')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('smartstudy_syllabus_contents', function (Blueprint $table) {
            $table->dropForeign(['syllabus_id']);
        });

        Schema::dropIfExists('smartstudy_syllabus_contents');


        Schema::table('smartstudy_syllabus_contents', function (Blueprint $table) {
            $table->dropForeign(['syllabus_id']);
        });
        Schema::dropIfExists('smartstudy_syllabuses');
    }
}
