<?php

namespace Vtlabs\Ride\Providers;

use Vtlabs\Ride\Events\NewRide;
use Vtlabs\Core\Events\LoggedIn;
use Vtlabs\Ride\Events\UpdateRide;
use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Ride\Listeners\NewRideListener;
use Vtlabs\Ride\Listeners\LoggedInListener;
use Vtlabs\Ride\Listeners\UpdateRideListener;
use Vtlabs\Ride\Listeners\RoleAssignedListener;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        LoggedIn::class => [LoggedInListener::class],
        RoleAssigned::class => [RoleAssignedListener::class],
        NewRide::class => [NewRideListener::class],
        UpdateRide::class => [UpdateRideListener::class]
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
