<?php

namespace Vtlabs\Ride\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;
use Vtlabs\Core\Services\GoogleDistanceService;

class VehicleType extends Model implements HasMedia
{
    use Filterable,
        CoreHasMediaTrait,
        HasTranslations;

    public static $estimations;

    protected $table = 'ride_vehicle_types';

    protected $guarded = [];

    protected $casts = [
        'title' => 'json',
        'meta' => 'json',
        'base_fare' => 'float',
        'time_charges_per_minute' => 'float',
        'other_charges' => 'float',
        'seats' => 'integer',
    ];

    public $translatable = ['title'];

    public function calculateFare($distance, $time)
    {
        return ($this->base_fare + ($distance * $this->distance_charges_per_unit) + ($time * $this->time_charges_per_minute) +
            $this->other_charges);
    }
}
