<?php

namespace Vtlabs\Ride\Models;

use Vtlabs\Ride\Models\Ride;
use EloquentFilter\Filterable;
use Vtlabs\Ride\Models\Driver;
use Illuminate\Database\Eloquent\Model;

class RideRequest extends Model
{
    use Filterable;

    protected $table = 'ride_riderequests';

    protected $guarded = [];

    protected $casts = [];

    public function ride()
    {
        return $this->belongsTo(Ride::class);
    }

    public function driver()
    {
        return $this->belongsTo(Driver::class);
    }

    public function updateStatus($status)
    {
        if ($this->status == $status) {
            return;
        }

        if ($status == 'accept') {
            $ride = $this->ride;
            $ride->ambulance_id = $this->ambulance_id;
            $ride->save();

            $ambulance = $this->ambulance;
            $ambulance->assigned = 1;
            $ambulance->save();

            $ride->updateStatus('assigned');
        }

        $this->status = $status;
        $this->save();
    }
}
