<?php

namespace Vtlabs\Ride\Models;

use EloquentFilter\Filterable;
use Vtlabs\Ride\Models\Driver;
use Vtlabs\Core\Models\User\User;
use Spatie\ModelStatus\HasStatuses;
use Vtlabs\Ride\Models\VehicleType;
use Vtlabs\Payment\Traits\CanBePaid;
use Vtlabs\Payment\Contracts\Payable;
use Illuminate\Database\Eloquent\Model;

class Ride extends Model implements Payable
{
    use Filterable,
    HasStatuses,
    CanBePaid;

    protected $table = 'ride_rides';

    protected $guarded = [];

    public static function boot()
    {
        parent::boot();

        // on create
        static::created(function ($order) {
            $order->setStatus(config('vtlabs_ride.ride.status_default'));
        });
    }

    public function isValidStatus(string $name, ?string $reason = null): bool
    {
        return in_array($name, config('vtlabs_ride.ride.status_list', []));
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function driver()
    {
        return $this->belongsTo(Driver::class);
    }

    public function vehicleType()
    {
        return $this->belongsTo(VehicleType::class);
    }
}
