<?php

namespace Vtlabs\Ride\Listeners;

use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Ride\Models\Driver;

class RoleAssignedListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  RoleAssigned $event
     * @return void
     */
    public function handle(RoleAssigned $event)
    {
        if(in_array('driver', $event->roles)) {
            if(!Driver::where('user_id', $event->user->id)->exists()) {
                Driver::create([
                    'user_id' => $event->user->id
                ]);
            }
        }
    }
}
