<?php

namespace Vtlabs\Ride\Listeners;

use Vtlabs\Ride\Events\NewRide;
use Illuminate\Support\Facades\Log;
use Vtlabs\Ride\Models\DriverRideLog;
use Vtlabs\Core\Services\FirebaseService;

class NewRideListener
{
    private $event;
    private $ride;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  NewRide $event
     * @return void
     */
    public function handle(NewRide $event)
    {

        $this->event = $event;
        $this->ride = $event->ride;

        DriverRideLog::create([
            'ride_id' => $this->ride->id,
            'driver_id' => $this->ride->driver_id
        ]);

        // write to firebase
        $firebaseDatabase = FirebaseService::getDatabaseInstance();
        if ($firebaseDatabase) {
            $firebaseDatabase->getReference('driver/' . $this->ride->driver->id . '/ride')->set($this->ride);
        }

        $this->ride->driver->user->sendPushNotification(
            'driver',
            __('vtlabs_ride::messages.notification_new_ride_title', ['id' => $this->ride->id]),
            __('vtlabs_ride::messages.notification_new_ride_body')
        );
    }
}
