<?php

namespace Vtlabs\Ride\Jobs;

use Carbon\Carbon;
use App\Helpers\Language;
use Vtlabs\Ride\Models\Ride;
use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Vtlabs\Core\Services\FirebaseService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class UpdateScheduledRide implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct() {}

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            Log::info("UpdateScheduledRide called");
            $rides = Ride::where('is_scheduled', true)
                ->where('is_scheduled_ready', false)
                ->where('ride_on', '<', Carbon::now()->addMinutes(10)->format("Y-m-d H:i:s"))
                ->where('status', 'accepted')
                ->orderBy('ride_on', 'desc')
                ->get()
                ->unique('drive_id');
            foreach ($rides as $ride) {
                $ride->is_scheduled_ready = 1;

                $driver = $ride->driver;
                $driver->is_riding = true;
                $driver->save();

                $ride->save();

                // firebase
                $firebaseDatabase = FirebaseService::getDatabaseInstance();
                $firebaseDatabase->getReference('/driver/' . $driver->id . '/ride')->set($ride);

                // notification
                $driver->user->sendPushNotification(
                    'driver',
                    __('ride::messages.notification_new_ride_title', ['id' => $ride->id]),
                    __('ride::messages.notification_new_ride_body')
                );
            }
        } catch (\Exception $ex) {
        }
    }
}
